//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~~//
// Arcane-FX
//    Changes:
//      Package FpsStarterKit changed to ArcaneFX_DEMO
//      References to Fps kit in messages changed to ArcaneFX 
//      Disabled saving of config changes
// Copyright (C) Faust Logic, Inc.
//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~~//

// Load up common script base
loadDir("common");

//-----------------------------------------------------------------------------
// Load up defaults console values.

// Defaults console values
exec("./client/defaults.cs");
exec("./server/defaults.cs");
$pref::Video::FirstDesktopDim = getDesktopResolution();

// Preferences (overide defaults)
// AFX CODE BLOCK <<
if (isFile($ClientPrefSaveFile))
  exec($ClientPrefSaveFile,0,0,1); // Need to specify that it is an absolute path
if (isFile($ServerPrefSaveFile))
  exec($ServerPrefSaveFile,0,0,1); // Need to specify that it is an absolute path
/// ORIGINAL CODE
///exec("./client/prefs.cs");
///exec("./server/prefs.cs");
// AFX CODE BLOCK >>

//-----------------------------------------------------------------------------
// Package overrides to initialize the mod.
package ArcaneFX_DEMO { // AFX

function displayHelp() {
   Parent::displayHelp();
   error(
      "Arcane-FX Mod options:\n"@	// AFX
      "  -dedicated             Start as dedicated server\n"@
      "  -connect <address>     For non-dedicated: Connect to a game at <address>\n" @
      "  -mission <filename>    For dedicated: Load the mission\n"
   );
}

function parseArgs()
{
   Parent::parseArgs();

   // Arguments, which override everything else.
   for (%i = 1; %i < $Game::argc ; %i++)
   {
      %arg = $Game::argv[%i];
      %nextArg = $Game::argv[%i+1];
      %hasNextArg = $Game::argc - %i > 1;
   
      switch$ (%arg)
      {
         //--------------------
         case "-dedicated":
            $Server::Dedicated = true;
            enableWinConsole(true);
            $argUsed[%i]++;

         //--------------------
         case "-mission":
            $argUsed[%i]++;
            if (%hasNextArg) {
               $missionArg = %nextArg;
               $argUsed[%i+1]++;
               %i++;
            }
            else
               error("Error: Missing Command Line argument. Usage: -mission <filename>");

         //--------------------
         case "-connect":
            $argUsed[%i]++;
            if (%hasNextArg) {
               $JoinGameAddress = %nextArg;
               $argUsed[%i+1]++;
               %i++;
            }
            else
               error("Error: Missing Command Line argument. Usage: -connect <ip_address>");
      }
   }
}

function onStart()
{
   Parent::onStart();
   echo("\n--------- Initializing MOD: ArcaneFX DEMO ---------");  // AFX

   // Load the scripts that start it all...
   exec("./client/client_init.cs");
   exec("./server/init.cs");
   //exec("./data/init.cs");

   // Server gets loaded for all sessions, since clients
   // can host in-game servers.
   initServer();

   // Start up in either client, or dedicated server mode
   if ($Server::Dedicated)
      initDedicated();
   else
      initClient();
}

function onExit()
{
   // WW2 CODE BLOCK <<
   // In case the game is exited prematurely
   clientEndGame(true);
   destroyServer();
   // WW2 CODE BLOCK >>
   
   echo("Exporting client prefs");
   //export("$pref::*", "./client/prefs.cs", False);
   export("$pref::*", $ClientPrefSaveFile, False);

   // AFX CODE BLOCK <<
   // not saving config changes for AFX demo.
   /// ORIGINAL CODE
   ///echo("Exporting client config");
   ///if (isObject(moveMap))
   ///   moveMap.save("./client/config.cs", false);
   // AFX CODE BLOCK >>

   echo("Exporting server prefs");
   //export("$Pref::Server::*", "./server/prefs.cs", False);
   export("$Pref::Server::*", $ServerPrefSaveFile, False);

   // Unneeded for Westward 2. In addition, writing to this location 
   // on the hard disk is forbidden in Vista
   //BanList::Export("./server/banlist.cs");

   Parent::onExit();
}

}; // Client package
activatePackage(ArcaneFX_DEMO);  // AFX
